/*****************************************************************************
 * Copyright (c) 2014-2026 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include <cstdint>

namespace OpenRCT2
{
    enum class GameCommand : int32_t
    {
        SetRideAppearance,
        SetLandHeight,
        TogglePause,
        PlaceTrack,
        RemoveTrack,
        LoadOrQuit,
        CreateRide,
        DemolishRide,
        SetRideStatus,
        SetRideVehicles,
        SetRideName,
        SetRideSetting,
        PlaceRideEntranceOrExit,
        RemoveRideEntranceOrExit,
        RemoveScenery,
        PlaceScenery,
        SetWaterHeight,
        PlacePath,
        PlacePathLayout,
        RemovePath,
        ChangeSurfaceStyle,
        SetRidePrice,
        SetGuestName,
        SetStaffName,
        RaiseLand,
        LowerLand,
        EditLandSmooth,
        RaiseWater,
        LowerWater,
        SetBrakesSpeed,
        HireNewStaffMember,
        SetStaffPatrol,
        FireStaffMember,
        SetStaffOrders,
        SetParkName,
        SetParkOpen,
        BuyLandRights,
        PlaceParkEntrance,
        RemoveParkEntrance,
        SetMazeTrack,
        SetParkEntranceFee,
        SetStaffColour,
        PlaceWall,
        RemoveWall,
        PlaceLargeScenery,
        RemoveLargeScenery,
        SetCurrentLoan,
        SetResearchFunding,
        PlaceTrackDesign,
        StartMarketingCampaign,
        PlaceMazeDesign,
        PlaceBanner,
        RemoveBanner,
        SetSceneryColour,
        SetWallColour,
        SetLargeSceneryColour,
        SetBannerColour,
        SetLandOwnership,
        ClearScenery,
        SetBannerName,
        SetSignName,
        SetBannerStyle,
        SetSignStyle,
        SetPlayerGroup,
        ModifyGroups,
        KickPlayer,
        Cheat,
        PickupGuest,
        PickupStaff,
        BalloonPress,
        ModifyTile,
        EditScenarioOptions,
        PlacePeepSpawn,
        SetColourScheme,
        SetStaffCostume,
        PlaceFootpathAddition,
        RemoveFootpathAddition,
        GuestSetFlags,
        SetDate,
        Custom,
        ChangeMapSize,
        FreezeRideRating,
        SetGameSpeed,
        SetRestrictedScenery,
        setRideVisibility,
        Count,
    };
}
