"use strict"

const fs = require("fs")
const path = require("path")

import("../acorn/src/unicode-property-data.js")
  .then(m => {
    return m.default[13].nonBinary.Script
  })
  .then(async(reScriptValuesAddedInES) => {
    const scriptValues = new Set()
    for await (const value of getLatestUnicodeScriptValues()) {
      scriptValues.add(value)
    }
    const scriptValuesAddedInUnicode = "export default " +
    JSON.stringify(
      [...scriptValues]
        // The unicode script values now follow the Unicode spec as of ES2023,
        // but prior to ES2022 they were listed in the ES2022 spec.
        // The generated file lists all the unicode script values except those listed before ES2022.
        .filter(value => !reScriptValuesAddedInES.test(value))
        .sort()
        .join(" ")
    )

    writeGeneratedFile("scriptValuesAddedInUnicode", scriptValuesAddedInUnicode)

    console.log("Done. The generated files must be committed.")
  })

function writeGeneratedFile(filename, content) {
  const comment = "// This file was generated by \"bin/" + path.basename(__filename) + "\". Do not modify manually!"
  fs.writeFileSync(path.resolve("./acorn/src/generated", filename + ".js"), comment + "\n" + content + "\n", "utf8")
}

/**
 * Gets the all unicode script values from the latest PropertyValueAliases.
 */
async function * getLatestUnicodeScriptValues() {
  const response = await fetch("https://unicode.org/Public/UCD/latest/ucd/PropertyValueAliases.txt")
  const lines = (await response.text()).split("\n")
  for (const line of lines) {
    if (!line || line.startsWith("#")) {
      continue
    }
    const [propertyAlias, alias, canonical, ...remaining] = line
      .split("#")[0] // strip comments
      .split(";") // split by semicolon
      .map((x) => x.trim()) // trim

    if (propertyAlias !== "sc") {
      continue
    }

    yield canonical
    yield alias
    yield * remaining
  }
}
