# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Tests for users templatetags."""

from django.contrib.auth.models import AnonymousUser
from django.urls import reverse

from debusine.db.context import context
from debusine.db.playground import scenarios
from debusine.test.django import TestCase
from debusine.web.templatetags.users import user_link


class UserTagsTests(TestCase):
    """Tests for users tags."""

    scenario = scenarios.DefaultScopeUser()

    def test_user_link_can_display(self) -> None:
        user = self.playground.create_user("test")
        user_url = reverse("user:detail", kwargs={"username": user.username})
        self.scenario.set_current()

        self.assertEqual(
            user_link(user), f'<a href="{user_url}">{user.username}</a>'
        )

    def test_user_link_cannot_display(self) -> None:
        user = self.playground.create_user("test")
        context.set_scope(self.scenario.scope)
        context.set_user(AnonymousUser())

        self.assertEqual(user_link(user), user.username)
