#!/usr/bin/python3
"""
Module file handling for Fortran: tests

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 Gnu Public License.
"""

import dhfortran.module as mod
from click.testing import CliRunner
from pathlib import Path
import pytest

# TODO test smod files handled

# TODO test sourcedir handled /ignored

# TO test tmpdir honoured

def test_dh_fortran_mod_cmdline1():
    runner = CliRunner()
    result = runner.invoke(mod.dh_fortran_mod, ['tests/test01/debian/tmp/lib/points.mod'])
    assert result.exit_code == 0

def test_dh_fortran_mod():
    """ Install mod files. Normal case"""
    runner = CliRunner()
    result = runner.invoke(mod.dh_fortran_mod, [])
    assert result.exit_code == 0

    
def test_detection_flang_21():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/flang-21/points.mod")
    assert (cmplr,version) == ("flang","1")

def test_which_compiler_gf14():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/gfortran-14/points.mod")
    assert (cmplr, version) == ("gfortran", "15")


def test_which_compiler_gf15():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/gfortran-15/points.mod")
    assert (cmplr, version) == ("gfortran", "16")


def test_which_compiler_gf15():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/gfortran-16/points.mod")
    assert (cmplr, version) == ("gfortran", "16")

    
def test_which_compiler_fn18():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/flang-new-18/points.mod")
    assert (cmplr, version) == ("flang","1")


def test_which_compiler_fn19():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/flang-new-19/points.mod")
    assert (cmplr, version) == ("flang","1")


def test_which_compiler_fn20():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/flang-new-20/points.mod")
    assert (cmplr, version) == ("flang","1")


def test_which_compiler_fn21():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/flang-21/points.mod")
    assert (cmplr, version) == ("flang","1")

def test_which_compiler_fn22():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/flang-22/points.mod")
    assert (cmplr, version) == ("flang","1")

def test_which_compiler_lfortran():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/lfortran/points.mod")
    assert cmplr == "lfortran"
    assert version.startswith("0.")

def test_which_compiler_intel():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/intel/points.mod")
    assert (cmplr, version) == ("intel","0")

def test_which_compiler_nvhpc():
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/nvhpc/points.mod")
    assert (cmplr,version) == ("nvhpc","35")


if __name__ == "__main__":
    import pytest

    pytest.main()
