/*************************************************************************
* Copyright (C) 2025 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

#ifndef _IPPCP_ML_ZETAS_H_
#define _IPPCP_ML_ZETAS_H_

#include "owndefs.h"

/*
 * Precomputed values for Algorithm 11: NTT()
 *    cp_zetas_multiply_ntt[i] = zeta ^ (2 * BitReverse_7(i) + 1) mod q
 */
static const Ipp16s cp_mlkem_zetas_multiply_ntt[128] = {
    17,    -17,   2761,  -2761, 583,   -583,  2649,  -2649, 1637,  -1637, 723,   -723,  2288,
    -2288, 1100,  -1100, 1409,  -1409, 2662,  -2662, 3281,  -3281, 233,   -233,  756,   -756,
    2156,  -2156, 3015,  -3015, 3050,  -3050, 1703,  -1703, 1651,  -1651, 2789,  -2789, 1789,
    -1789, 1847,  -1847, 952,   -952,  1461,  -1461, 2687,  -2687, 939,   -939,  2308,  -2308,
    2437,  -2437, 2388,  -2388, 733,   -733,  2337,  -2337, 268,   -268,  641,   -641,  1584,
    -1584, 2298,  -2298, 2037,  -2037, 3220,  -3220, 375,   -375,  2549,  -2549, 2090,  -2090,
    1645,  -1645, 1063,  -1063, 319,   -319,  2773,  -2773, 757,   -757,  2099,  -2099, 561,
    -561,  2466,  -2466, 2594,  -2594, 2804,  -2804, 1092,  -1092, 403,   -403,  1026,  -1026,
    1143,  -1143, 2150,  -2150, 2775,  -2775, 886,   -886,  1722,  -1722, 1212,  -1212, 1874,
    -1874, 1029,  -1029, 2110,  -2110, 2935,  -2935, 885,   -885,  2154,  -2154
};

/*
 * Precomputed values for Algorithm 9 and Algorithm 11: NTT()
 *    cp_zetas_ntt[i] = zeta ^ BitReverse_7(i) mod q
 */
static const Ipp16s cp_mlkem_zetas_ntt[128] = {
    1,    1729, 2580, 3289, 2642, 630,  1897, 848,  1062, 1919, 193,  797,  2786, 3260, 569,  1746,
    296,  2447, 1339, 1476, 3046, 56,   2240, 1333, 1426, 2094, 535,  2882, 2393, 2879, 1974, 821,
    289,  331,  3253, 1756, 1197, 2304, 2277, 2055, 650,  1977, 2513, 632,  2865, 33,   1320, 1915,
    2319, 1435, 807,  452,  1438, 2868, 1534, 2402, 2647, 2617, 1481, 648,  2474, 3110, 1227, 910,
    17,   2761, 583,  2649, 1637, 723,  2288, 1100, 1409, 2662, 3281, 233,  756,  2156, 3015, 3050,
    1703, 1651, 2789, 1789, 1847, 952,  1461, 2687, 939,  2308, 2437, 2388, 733,  2337, 268,  641,
    1584, 2298, 2037, 3220, 375,  2549, 2090, 1645, 1063, 319,  2773, 757,  2099, 561,  2466, 2594,
    2804, 1092, 403,  1026, 1143, 2150, 2775, 886,  1722, 1212, 1874, 1029, 2110, 2935, 885,  2154
};

// zetas from the ML-DSA spec in montgomery form. Formula:
// auto y = (zetas[i] << 32) % q;
// if(y > q/2) y -= q;
// montgomery_zetas_ntt[i] = y;

__ALIGN64 static const Ipp32s cp_mldsa_montgomery_zetas_ntt[256] = {
    0,        25847,    -2608894, -518909,  237124,   -777960,  -876248,  466468,   1826347,
    2353451,  -359251,  -2091905, 3119733,  -2884855, 3111497,  2680103,  2725464,  1024112,
    -1079900, 3585928,  -549488,  -1119584, 2619752,  -2108549, -2118186, -3859737, -1399561,
    -3277672, 1757237,  -19422,   4010497,  280005,   2706023,  95776,    3077325,  3530437,
    -1661693, -3592148, -2537516, 3915439,  -3861115, -3043716, 3574422,  -2867647, 3539968,
    -300467,  2348700,  -539299,  -1699267, -1643818, 3505694,  -3821735, 3507263,  -2140649,
    -1600420, 3699596,  811944,   531354,   954230,   3881043,  3900724,  -2556880, 2071892,
    -2797779, -3930395, -1528703, -3677745, -3041255, -1452451, 3475950,  2176455,  -1585221,
    -1257611, 1939314,  -4083598, -1000202, -3190144, -3157330, -3632928, 126922,   3412210,
    -983419,  2147896,  2715295,  -2967645, -3693493, -411027,  -2477047, -671102,  -1228525,
    -22981,   -1308169, -381987,  1349076,  1852771,  -1430430, -3343383, 264944,   508951,
    3097992,  44288,    -1100098, 904516,   3958618,  -3724342, -8578,    1653064,  -3249728,
    2389356,  -210977,  759969,   -1316856, 189548,   -3553272, 3159746,  -1851402, -2409325,
    -177440,  1315589,  1341330,  1285669,  -1584928, -812732,  -1439742, -3019102, -3881060,
    -3628969, 3839961,  2091667,  3407706,  2316500,  3817976,  -3342478, 2244091,  -2446433,
    -3562462, 266997,   2434439,  -1235728, 3513181,  -3520352, -3759364, -1197226, -3193378,
    900702,   1859098,  909542,   819034,   495491,   -1613174, -43260,   -522500,  -655327,
    -3122442, 2031748,  3207046,  -3556995, -525098,  -768622,  -3595838, 342297,   286988,
    -2437823, 4108315,  3437287,  -3342277, 1735879,  203044,   2842341,  2691481,  -2590150,
    1265009,  4055324,  1247620,  2486353,  1595974,  -3767016, 1250494,  2635921,  -3548272,
    -2994039, 1869119,  1903435,  -1050970, -1333058, 1237275,  -3318210, -1430225, -451100,
    1312455,  3306115,  -1962642, -1279661, 1917081,  -2546312, -1374803, 1500165,  777191,
    2235880,  3406031,  -542412,  -2831860, -1671176, -1846953, -2584293, -3724270, 594136,
    -3776993, -2013608, 2432395,  2454455,  -164721,  1957272,  3369112,  185531,   -1207385,
    -3183426, 162844,   1616392,  3014001,  810149,   1652634,  -3694233, -1799107, -3038916,
    3523897,  3866901,  269760,   2213111,  -975884,  1717735,  472078,   -426683,  1723600,
    -1803090, 1910376,  -1667432, -1104333, -260646,  -3833893, -2939036, -2235985, -420899,
    -2286327, 183443,   -976891,  1612842,  -3545687, -554416,  3919660,  -48306,   -1362209,
    3937738,  1400424,  -846154,  1976782
};

#endif // #ifndef _IPPCP_ML_ZETAS_H_
