//
//  ========================================================================
//  Copyright (c) 1995-2022 Mort Bay Consulting Pty Ltd and others.
//  ------------------------------------------------------------------------
//  All rights reserved. This program and the accompanying materials
//  are made available under the terms of the Eclipse Public License v1.0
//  and Apache License v2.0 which accompanies this distribution.
//
//      The Eclipse Public License is available at
//      http://www.eclipse.org/legal/epl-v10.html
//
//      The Apache License v2.0 is available at
//      http://www.opensource.org/licenses/apache2.0.php
//
//  You may elect to redistribute this code under either of these licenses.
//  ========================================================================
//

package org.eclipse.jetty.start.usecases;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.jetty.toolchain.test.FS;
import org.junit.jupiter.api.Test;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.containsString;

public class LoopTest extends AbstractUseCase
{
    @Test
    public void testLoopTest() throws Exception
    {
        setupStandardHomeDir();

        FS.ensureDirExists(baseDir.resolve("modules"));

        // Create loop
        // richard -> harry -> tom -> richard

        Files.write(baseDir.resolve("modules/branch.mod"),
            Arrays.asList(
                "[provides]",
                "branch"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/richard.mod"),
            Arrays.asList(
                "[depends]",
                "harry"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/harry.mod"),
            Arrays.asList(
                "[depends]",
                "tom"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/other.mod"),
            Arrays.asList(
                "[provides]",
                "branch"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/root.mod"),
            Arrays.asList(
                "[depends]",
                "branch"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/tom.mod"),
            Arrays.asList(
                "[depends]",
                "richard"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("start.ini"),
            Collections.singletonList(
                "--module=root"
            ),
            StandardCharsets.UTF_8);

        // === Prepare Jetty Base using Main
        List<String> prepareArgs = Arrays.asList(
            "--testing-mode",
            "--create-startd",
            "--add-to-start=tom"
        );
        exec(prepareArgs, true);

        // === Execute Main
        List<String> runArgs = Collections.emptyList();
        ExecResults results = exec(runArgs, false);

        // === Check Exceptions
        assertThat(results.exception.toString(), containsString("CyclicException"));
        assertThat(results.exception.toString(), containsString("cyclic"));
    }

    @Test
    public void testDynamicLoopTest() throws Exception
    {
        setupStandardHomeDir();

        FS.ensureDirExists(baseDir.resolve("modules/dynamic"));
        FS.ensureDirExists(baseDir.resolve("modules"));

        // Create loop
        // richard -> dynamic/harry -> tom -> richard

        Files.write(baseDir.resolve("modules/branch.mod"),
            Arrays.asList(
                "[provides]",
                "branch"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/richard.mod"),
            Arrays.asList(
                "[depends]",
                "dynamic/harry"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/dynamic/harry.mod"),
            Arrays.asList(
                "[depends]",
                "tom"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/other.mod"),
            Arrays.asList(
                "[provides]",
                "branch"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/root.mod"),
            Arrays.asList(
                "[depends]",
                "branch"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("modules/tom.mod"),
            Arrays.asList(
                "[depends]",
                "richard"
            ),
            StandardCharsets.UTF_8);
        Files.write(baseDir.resolve("start.ini"),
            Collections.singletonList(
                "--module=root"
            ),
            StandardCharsets.UTF_8);

        // === Prepare Jetty Base using Main
        List<String> prepareArgs = Arrays.asList(
            "--testing-mode",
            "--create-startd",
            "--add-to-start=tom"
        );
        exec(prepareArgs, true);

        // === Execute Main
        List<String> runArgs = Collections.emptyList();
        ExecResults results = exec(runArgs, false);

        // === Check Exceptions
        assertThat(results.exception.toString(), containsString("CyclicException"));
        assertThat(results.exception.toString(), containsString("cyclic"));
    }
}
